import jestEnvironmentNode from 'jest-environment-node';

export default class FailFastEnvironment extends jestEnvironmentNode.default {
  constructor(...rest) {
    super(...rest);
    this.failed = false;
  }

  async handleTestEvent(event, state) {
    switch (event.name) {
    case 'hook_failure':
    case 'test_fn_failure':
      this.failed = true;
      break;
    case 'test_start':
      if (this.failed) {
        event.test.mode = 'skip';
      }
      break;
    default:
    }
    if (super.handleTestEvent !== undefined) {
      await super.handleTestEvent(event, state);
    }
  }
}
